unit Democlok;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Toggler, StdCtrls, Custbtn, AnaClock, Ledgadgt;

type
  TClocks = class(TForm)
    LEDClock1: TLEDClock;
    AnalogClock1: TAnalogClock;
    ShadowButton1: TShadowButton;
    chkShowSecs: TLEDCheckBox;
    GroupBox1: TGroupBox;
    rbCircle: TBWCCRadioButton;
    rbSquare: TBWCCRadioButton;
    procedure chkShowSecsClick(Sender: TObject);
    procedure rbCircleClick(Sender: TObject);
    procedure rbSquareClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Clocks: TClocks;

implementation

{$R *.DFM}

uses Demomain, Balloon;

procedure TClocks.chkShowSecsClick(Sender: TObject);
begin
  LEDClock1.ShowSeconds := chkShowSecs.Checked;
  AnalogClock1.ShowSeconds := chkShowSecs.Checked;
end;

procedure TClocks.rbCircleClick(Sender: TObject);
begin
  AnalogClock1.Shape := csCircle;
end;

procedure TClocks.rbSquareClick(Sender: TObject);
begin
  AnalogClock1.Shape := csSquare;
end;

procedure TClocks.FormCreate(Sender: TObject);
begin
  rbCircle.Checked := True;
  chkShowSecs.Checked := True;
end;

end.
